/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.NullADQLIterator;
import adql.query.operand.ADQLOperand;

public final class NumericConstant
implements ADQLOperand {
    private String value;

    public NumericConstant(String string) throws NumberFormatException {
        this(string, true);
    }

    public NumericConstant(long l) {
        this("" + l, false);
    }

    public NumericConstant(double d) {
        this("" + d, false);
    }

    public NumericConstant(String string, boolean bl) throws NumberFormatException {
        this.setValue(string, bl);
    }

    public NumericConstant(NumericConstant numericConstant) {
        this.value = numericConstant.value;
    }

    public final String getValue() {
        return this.value;
    }

    public final double getNumericValue() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public final void setValue(long l) {
        this.value = "" + l;
    }

    public final void setValue(double d) {
        this.value = "" + d;
    }

    public final void setValue(String string) throws NumberFormatException {
        this.setValue(string, true);
    }

    public final void setValue(String string, boolean bl) throws NumberFormatException {
        if (bl) {
            Double.parseDouble(string);
        }
        this.value = string;
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public final boolean isString() {
        return false;
    }

    @Override
    public final boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLObject getCopy() {
        return new NumericConstant(this);
    }

    @Override
    public String getName() {
        return this.value;
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    @Override
    public String toADQL() {
        return this.value;
    }
}

